/* Programme "calculatrice" et convertisseur Franc-Euro.
Programmé par Maniack Crudelis.
http://www.crudelis.fr
Pour des questions, remarques, suggestions et le support. Rendez-vous sur le forum du site.
Version 2.2. */
/*Copyright (c) 2008 Hervé Cottin.

Calc est un logiciel libre; vous pouvez le redistribuer et/ou le modifier selon les termes de la GNU General Public License (Licence Publique Générale GNU) telle qu'elle a été publiée par la Free Software Foundation; soit la version 3 de la licence, soit (comme vous le souhaitez) toute version ultérieure.

Calc est distribué dans l'espoir qu'il sera utile, mais SANS LA MOINDRE GARANTIE; pas même la garantie implicite de COMMERCIABILITE ou d'ADEQUATION A UN BUT PARTICULIER.
Voir la GNU General Public License pour plus de détails.

Vous devriez avoir reçu une copie de la GNU General Public License en même temps que ce programme; sinon, merci d'écrire à la Free Software Foundation, Inc, 59 Temple Place, Suite 330, Boston, MA02111-1307 USA.*/

#include <stdio.h>
#include "Utilitaire.h"
#include "Chaines.h"

float Calculatrice(float prec);

int main (int argc,char *argv[])
{
    float rez, prec=0;
    init_historique_saisie();
    Titre (argc,argv,"Calculatrice","Module de simulation de calculatrice simplifiée","03");
    putsacc(">Taper 'q' pour quitter.\n>Le mot clé '!' permet de réutiliser le résultat du calcul précédent.\n\n");
    putsacc(">Convertisseur Euro-Franc.\n    Pour convertir en Franc, faire suivre la valeur à convertir de F.\n");
    putsacc("    Pour convertir en Euro, faire suivre la valeur à convertir de E.\n    La conversion peut être incluse au sein d'un calcul.\n\n");
    do
    {
        printf("?:");
        rez = Calculatrice(prec);
        printf("= %.3f (=%f)\n", rez, rez);
        prec = rez;
    } while (1);
    return 0;
}

float Calculatrice(float prec)
{
    char chaine[100], signes[50];
    float nombres[50];
    int i,j,k,b1=0,b2=0,b3,nbparo=0,nbparf=0,nbmuldiv=0,nbt=0,index=0;
    int indexparo[50], indexparf[50], indexmuldiv[50];
    float temp,nb1,nb2;
    strcpy(chaine,nomajloc_calc(chfunc));
    i = strlen(chaine);    /*i = taille complète du calcul*/
    if (!i)    /*Si la chaine est vide, renvoi une erreur*/
        return (defo);
    while (strlen(chaine))
    {
        if (isdigit(chaine[0]) > 0 || chaine[0] == '!')
        {        /*Si le premier caractère est un chiffre ou le rappel du calcul précédent*/
            b1=1;        /*indique nombres*/
            if (chaine[0] == '!')
            {
                nombres[index] = prec;    /*stocke valeur du résultat précédent dans le tableau 1*/
                for (i=0;i<strlen(chaine);i++)
                    chaine[i] = chaine[i+1];    /*supprime le !*/
            }
            else
                nombres[index] = atof(chaine);    /*Saisi valeur et stocke dans le tableau 1*/
            if (b2==1)            /*Valeur négative*/
                nombres[index]*=-1;
            b2=0;
            signes[index++] = '0';      /*Met 0 dans le tableau 2*/
            nbt++;
            while (isdigit(chaine[0]) || chaine[0] == '.')
            {            /*retire la valeur saisie de la string*/
                for (i=0;i<strlen(chaine);i++)
                    chaine[i] = chaine[i+1];
            }
            /*Conversion franc-euro, euro-franc*/
            if(chaine[0] == 'E' || chaine[0] == 'F')
            {   /*Conversion demandée*/
                if(chaine[0] == 'E')   /*Conversion en Euro*/
                {
                    puts("->Conversion en Euro");
                    nombres[index-1] /= 6.55957;
                }
                if(chaine[0] == 'F')   /*Conversion en Franc*/
                {
                    puts("->Conversion en Franc");
                    nombres[index-1] *= 6.55957;
                }
                for (i=0;i<strlen(chaine);i++)
                    chaine[i] = chaine[i+1];    /*supprime le E ou F*/
            }
        }
        else
        {        /*Donc si signe de calcul*/
            if (chaine[0] == '-' && b1 == 0)
            {            /*Si un - se trouve apres un autre signe*/
                b2=1;            /*Nombre négatif*/
                nombres[index] = 0;     /*Place 0 et # dans les tableaux*/
                signes[index++] = '#';
                nbt++;
            }
            else
            {    /*Si c'est pas un nb négatif*/
                b1=0;      /*Indique signe*/
                signes[index] = chaine[0];   /*Place 0 dans le tableau 1 et le signe dans le tableau 2*/
                nombres[index++] = 0;
                nbt++;
                switch (signes[index-1])
                {        /*reperage du signe utilisé*/
                    case '*':
                    case '/':
                        indexmuldiv[nbmuldiv] = index-1;
                        nbmuldiv+=1;
                        break;
                    case '(':
                        indexparo[nbparo] = index-1;
                        nbparo+=1;
                        break;
                    case ')':
                        indexparf[nbparf] = index-1;
                        nbparf+=1;
                        break;
                    case '+':
                    case '-':
                        break;
                    default:   /*Si aucun signe n'est reconnu*/
                        printf("Erreur: le symbole %c n'est pas reconnu", signes[index-1]);
                        Pause();
                        return NA;
                }
            }
            for (i=0;i<strlen(chaine);i++)
                chaine[i] = chaine[i+1]; /*Retire le signe de la string*/
        }
    }
    if (nbparo != nbparf)
    {    /*Si ya pa autant de parenthèses ouvrantes et fermantes*/
        printf("Erreur: %d parentheses ouvertes, %d parentheses fermees", nbparo,nbparf);
        Pause();
        return NA;
    }
    do
    {
        if (nbparo) /*Si ya des parentheses*/
        {
            b2 = indexparf[0];     /*borne 2 à la 1ere parenthèse fermante*/
            for (i=0;i<nbparo;i++)
            {
                if (indexparo[i] < b2)  /*Si la parenthese ouvrante est avant la fermante*/
                    b1 = indexparo[i];  /*borne 1 à la parenthese*/
            }                    /*Donc les 2 bornes se resserrent sur les plus profondes parenthèses*/
            signes[b1] = '#';   /*Place des # à la place des parenthèses utilisées*/
            signes[b2] = '#';
            nbparo--;
            for (i=b1;i<nbparo;i++)     /*Supprime les index des parenthèses utilisées*/
                indexparo[i] = indexparo[i+1];
            for (i=0;i<nbparo;i++)
                indexparf[i] = indexparf[i+1];
        }
        else
        {        /*Si ya pas de parenthèses, ou plus de parenthèses*/
            b1 = -1;     /*Bornes à -1 et max*/
            b2 = nbt;
        }
        for (i=0;i<nbmuldiv;i++)
        {        /*Boucle sur le nombre de signes * ou / */
            if (indexmuldiv[i] > b1 && indexmuldiv[i] < b2)
            {            /*Si le signe se trouve entre les 2 bornes*/
                b3 = indexmuldiv[i];    /*Borne 3 à l'emplacement du signe*/
                indexmuldiv[i] = -1;    /*index du signes à -1*/
            }
            else
                b3 = -1;  /*sinon borne 3 à -1*/
            if (b3 != -1)
            {    /*Si la borne 3 est utilisée*/
                for(j=b3-1;j>b1;j--)
                {       /*Saisi valeur 1*/
                    if (nombres[j] || (!nombres[j] && signes[j] == '0'))
                    {      /*Si le nombre est différent de 0 ou qu'il est égal à 0 et que le tab 2 contient aussi 0*/
                        nb1 = nombres[j];
                        signes[j] = '#';   /*Place 0 et # dans les tableaux*/
                        nombres[j] = 0;
                        break;
                    }
                }
                for(k=b3+1;k<b2;k++)
                {       /*Saisi valeur 2... idem*/
                    if (nombres[k] || (!nombres[k] && signes[k] == '0'))
                    {
                        nb2 = nombres[k];
                        signes[k] = '#';
                        nombres[k] = 0;
                        break;
                    }
                }
                if (k==b2)
                {   /*Si aucune valeur n'est trouvée pour nb2*/
                    nombres[j] = nb1;   /*Replace nb1 dans le tableau 1, puis met 0 dans le tableau 2*/
                    signes[j] = '0';
                }
                if (signes[b3] == '*')
                    temp = nb1*nb2;      /*Multiplication*/
                if (signes[b3] == '/')
                {
                    if (nb2 == 0)
                    {
                        puts("Erreur: Division par 0 !!!");
                        Pause();
                        return NA;
                    }
                    temp = nb1/nb2;     /*Division*/
                }
                signes[b3] = '0';    /*Met 0 dans le tableau 2*/
                nombres[b3] = temp;  /*Place le résultat du calcul dans le tableau 1*/
            }
        }
        for(i=b1+1;i<b2;i++)
        {
            for(j=b1+1;j<b2;j++)
            {         /*Saisi valeur 1*/
                if (nombres[j] != 0 || (!nombres[j] && signes[j] == '0'))
                {
                    nb1 = nombres[j];
                    signes[j] = '#';
                    nombres[j] = 0;
                    break;
                }
            }
            for(k=b1+1;k<b2;k++)
            {        /*Saisi valeur 2*/
                if (nombres[k] || (!nombres[k] && signes[k] == '0'))
                {
                    nb2 = nombres[k];
                    signes[k] = '#';
                    nombres[k] = 0;
                    break;
                }
            }
            if (k==b2)
            {
                nombres[j] = nb1;
                signes[j] = '0';
            }
            for(j=b1+1;j<b2;j++)
            {
                switch (signes[j])
                {
                    case '+':
                        temp = nb1+nb2;     /*Addition*/
                        break;
                    case '-':
                        temp = nb1-nb2;     /*Soustraction*/
                        break;
                }
                if (signes[j] == '+' || signes[j] == '-')
                {      /*Si addition ou soustraction*/
                    signes[j] = '0';     /*Met 0 dans le tableau 2*/
                    nombres[j] = temp;   /*Et le resultat du calcul dans le tableau 1*/
                    break;
                }
            }
        }
    } while (b1 != -1 || b2 != nbt); /*Fin du calcul si les bornes sont maximum*/
    i=0;
    do
    {
        temp = nombres[i];    /*Prend comme résultat la seule valeur restant dans le tableau*/
    } while (!temp && ++i<nbt);
    return temp; /*Renvoi le résultat du calcul*/
}
